/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.lpar;

import com.ibm.hsc.auiml.databeans.dlpar.PIHscDlparBean;
import com.ibm.hsc.auiml.databeans.lpar.HSCDLPARBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskHelpListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOXContainerObj;

public abstract class PIDlparDialog {
    public static final String DLPAR_BUNDL_NAME = "PIDLPARBundle";
    public static final String ERR_DLPAR_NOT_ENABLED = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_DLPAR_NOT_ENABLED", "The current selected partition is not enabled for dynamic reconfiguration operations.");

    protected abstract String getNoResError();

    protected abstract HSCDLPARBean getBeanExtObj();

    public void createDialog(MOXContainerObj mOXContainerObj, PIHscDlparBean pIHscDlparBean, String string) {
        try {
            if (IDebug.enabled) {
                System.err.println("before bean load");
            }
            if (pIHscDlparBean.getLoadException() != null) {
                return;
            }
            String string2 = pIHscDlparBean.getDlparTask();
            String string3 = "";
            if (string2.trim().equals("Proc")) {
                string3 = "cpu";
            } else if (string2.trim().equals("Mem")) {
                string3 = "mem";
            } else if (string2.trim().equals("PIO")) {
                string3 = "slot";
            }
            if (!pIHscDlparBean.isResourceDlparCabable(string3)) {
                pIHscDlparBean.showInfo(ERR_DLPAR_NOT_ENABLED, null, null);
                return;
            }
            if (!pIHscDlparBean.dlparEnabled()) {
                pIHscDlparBean.showInfo(ERR_DLPAR_NOT_ENABLED, null, null);
                return;
            }
            if (pIHscDlparBean.needToDisableAll()) {
                pIHscDlparBean.showInfo(this.getNoResError(), null, null);
                return;
            }
            if (string.equals("add")) {
                if (pIHscDlparBean.needToDisableAdd()) {
                    String string4 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDL_NAME, "ADD_DISABLED", "There is no resource available to add");
                    pIHscDlparBean.showInfo(string4, null, null);
                    return;
                }
                if (pIHscDlparBean.cannotAdd()) {
                    String string5 = "";
                    if (string3.equals("mem")) {
                        string5 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDL_NAME, "ERR_MEM_ADD_MAX_CURRENT_EQUAL", "The desired and maximum memory values are equal. Please check your Partition Profile definition.");
                    }
                    if (string3.equals("cpu")) {
                        string5 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDL_NAME, "ERR_CPU_ADD_MAX_CURRENT_EQUAL", "The desired and maximum processor values are equal. Please check your Partition Profile definition.");
                    }
                    pIHscDlparBean.showInfo(string5, null, null);
                    return;
                }
            }
            if (string.equals("remove")) {
                if (pIHscDlparBean.needToDisableRemove()) {
                    String string6 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDL_NAME, "REMOVE_DISABLED", "There is no resource available to remove");
                    pIHscDlparBean.showInfo(string6, null, null);
                    return;
                }
                if (pIHscDlparBean.cannotRemove()) {
                    String string7 = "";
                    if (string3.equals("mem")) {
                        string7 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDL_NAME, "ERR_MEM_REMOVE_MIN_CURRENT_EQUAL", "The minimum and desired memory values are equal. Please check your Partition Profile definition.");
                    }
                    if (string3.equals("cpu")) {
                        string7 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDL_NAME, "ERR_CPU_REMOVE_MIN_CURRENT_EQUAL", "The minimum and desired processor values are equal. Please check your Partition Profile definition.");
                    }
                    pIHscDlparBean.showInfo(string7, null, null);
                    return;
                }
            }
            if (string.equals("move")) {
                if (pIHscDlparBean.needToDisableMove()) {
                    String string8 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDL_NAME, "MOVE_DISABLED", "There is no resource available to move");
                    pIHscDlparBean.showInfo(string8, null, null);
                    return;
                }
                if (pIHscDlparBean.cannotRemove()) {
                    String string9 = "";
                    if (string3.equals("mem")) {
                        string9 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDL_NAME, "ERR_MEM_REMOVE_MIN_CURRENT_EQUAL", "The minimum and desired memory values are equal. Please check your Partition Profile definition.");
                    }
                    if (string3.equals("cpu")) {
                        string9 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDL_NAME, "ERR_CPU_REMOVE_MIN_CURRENT_EQUAL", "The minimum and desired processor values are equal. Please check your Partition Profile definition.");
                    }
                    pIHscDlparBean.showInfo(string9, null, null);
                    return;
                }
            }
            DataBean[] dataBeanArray = new DataBean[]{pIHscDlparBean};
            AuimlAdapter auimlAdapter = new AuimlAdapter(pIHscDlparBean.getAuimlClassName(), pIHscDlparBean.getMainPanelName(), dataBeanArray);
            UserTaskManager userTaskManager = auimlAdapter.getUserTaskManager();
            pIHscDlparBean.setPanelState(false);
            pIHscDlparBean.setUsrTaskMgr(userTaskManager);
            userTaskManager.addTaskActionListener((TaskActionListener)pIHscDlparBean);
            userTaskManager.setTaskHelpListener((TaskHelpListener)pIHscDlparBean);
            auimlAdapter.showIt();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            pIHscDlparBean.handleException(throwable);
        }
    }

    public void createDialog(MOXContainerObj mOXContainerObj, String string) {
        HSCDLPARBean hSCDLPARBean = this.getBeanExtObj();
        try {
            hSCDLPARBean.setServerConn(mOXContainerObj);
            if (IDebug.enabled) {
                System.out.println("before bean load");
            }
            hSCDLPARBean.load();
            if (hSCDLPARBean.getLoadException() != null) {
                return;
            }
            if (!hSCDLPARBean.dlparEnabled()) {
                hSCDLPARBean.showInfo(ERR_DLPAR_NOT_ENABLED, null, null);
                return;
            }
            if (hSCDLPARBean.needToDisableAll()) {
                hSCDLPARBean.showInfo(this.getNoResError(), null, null);
                return;
            }
            if (IDebug.enabled) {
                System.out.println("after bean load");
            }
            DataBean[] dataBeanArray = new DataBean[]{hSCDLPARBean};
            AuimlAdapter auimlAdapter = new AuimlAdapter(hSCDLPARBean.getAuimlClassName(), hSCDLPARBean.getMainPanelName(), dataBeanArray);
            UserTaskManager userTaskManager = auimlAdapter.getUserTaskManager();
            hSCDLPARBean.setUsrTaskMgr(userTaskManager);
            userTaskManager.addTaskActionListener((TaskActionListener)hSCDLPARBean);
            auimlAdapter.showIt();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            hSCDLPARBean.handleException(throwable);
        }
    }
}

